<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "include/controlloLogin.php";
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $tipo              = isset($_GET["tipo"]) ? filter_input(INPUT_GET,"tipo",FILTER_SANITIZE_ADD_SLASHES) : "";
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_ADD_SLASHES) : "";
    $status 		= (isset($_GET["status"])) ? filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT) : 0;
    
    if($tipo=="prima nota") {
        $titoloPagina      = "Elenco voci prima nota";
        $titoloBottoneCrea = "Crea voce prima nota";
    }
    else if($tipo=="fattura") {
        $titoloPagina = "Elenco fatture";
        $titoloBottoneCrea = "Crea fattura";
    }
    else if($tipo=="ricevuta") {
        $titoloPagina = "Elenco ricevute";
        $titoloBottoneCrea = "Crea ricevuta";
    }
    else if($tipo=="preventivo") {
        $titoloPagina = "Elenco preventivi";
        $titoloBottoneCrea = "Crea preventivo";
    }
    
    $parametriRicerca = array("tipo"=>$tipo,"oggetto"=>$cerca);
    $parametri = array("tabella"=>"geecAd_documentiContabili", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"documentiContabili.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Amministrazione di Geecom Admin - <?php echo $titoloPagina ?></title>

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
    </head>

    <body>

        <header>
            <?php  
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div id="contenutoPrincipale" class="row">
                    <div class="col py-4">
                    <?php
                            if($status==200) {
		                    echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
				            Creazione prima nota riuscita
				            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
				                  <span aria-hidden=\"true\">&times;</span>
				            </button>
			                </div>";
                            }
                            else if($status==250) {
		                    echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
				            Voce prima nota modificata
				            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
				                  <span aria-hidden=\"true\">&times;</span>
				            </button>
			                </div>";
                            }
                    ?>
                        <div class="card mb-4 box-shadow-lite">
                            <div class="card-header">
                                <span class="card-title mr-2"><?php echo $titoloPagina ?></span>
                                <a href="<?= ($tipo=="prima nota") ? "javascript:void" : "creaDocumentoContabile.php?tipo=$tipo" ?>" <?= ($tipo=="prima nota") ? " data-toggle=\"modal\" data-target=\"#modalCreaVocePrimaNota\"" : "" ?> class="btn btn-sm btn-primary" >
                                    <?php echo $titoloBottoneCrea ?><i class="fas fa-plus ml-2"></i>
                                </a>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca,array("tipo"=>$tipo));
                                        $ricerca->stampaFormRicerca($cerca,array("tipo"=>$tipo));
                                    ?>
                                </div>
                                <div class="table-responsive table-sm">
                                    <?php

                                        if(isset($_GET["pag"])) {
                                            $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                        }
                                        else {
                                            $ris = $ricerca->eseguiRicerca(1);
                                        }

                                        if($tipo=="ricevuta" || $tipo=="fattura") {
                                            $colonne = array("ID","N.","Data emissione","Cliente","Totale €","");
                                        }
                                        else {
                                            $colonne = array("ID","N.","Data emissione","Oggetto","Cliente","Totale €","");
                                        }

                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                        $tabella->setTipo("normale");
                                        while($documento = $ris->fetch_assoc()) {
                                            if($documento["idUtente"]==0) {
                                                $nomeClienteEscape = "Non impostato";
                                            }
                                            else {
                                                $cliente = $geecomDb->leggiSingolaRiga("geec_utenti",$documento["idUtente"]);
                                                $nomeClienteEscape = "<a href=\"creaUtente.php?id={$documento["idUtente"]}\">".filter_var($cliente["nome"]." ".$cliente["cognome"],FILTER_SANITIZE_ADD_SLASHES)."</a>";
                                            }
                                            
                                            $oggettoEscape = filter_var($documento["oggetto"],FILTER_SANITIZE_ADD_SLASHES);
                                            $classe	     = ($documento["entrataUscita"]=="Entrata") ? "success" : "danger";
                                            
                                            $dataEmissione = date("d/m/Y", strtotime($documento["dataEmissione"]));
                                            if($tipo=="prima nota") {
		                                    $testoEscape = filter_var($documento["testo"],FILTER_SANITIZE_ADD_SLASHES);
                                            		
		                                    $azioni = array("personalizzato"=>"<a class=\"btn visualizza\" href=\"#\" onclick=\"modificaPrimaNota({$documento["id"]},'$oggettoEscape','{$documento["entrataUscita"]}',{$documento["idUtente"]},{$documento["totale"]},'{$documento["metodoPagamento"]}','{$documento["dataPagamento"]}','$testoEscape')\"  data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\"><i class=\"fas fa-edit\"></i> </a>","elimina"=>"eliminaDocumentoContabile({$documento["id"]},'$oggettoEscape')");
                                            }
                                            else {
		                                    $azioni = array("modifica"=>"creaDocumentoContabile.php?id={$documento["id"]}","elimina"=>"eliminaDocumentoContabile({$documento["id"]},'$oggettoEscape')");
                                            }

                                            if($tipo=="ricevuta" || $tipo=="fattura") {
                                                $tabella->aggiungiNuovaRiga(array($documento["id"],$documento["numeroDocumento"]." <a href=\"creaDocumentoContabile.php?id={$documento["id"]}\"><i class=\"fas fa-external-link-alt ml-2\"></i></a>",$dataEmissione,$nomeClienteEscape,"<span class=\"text-$classe\">".$documento["totale"]."</span>"),$azioni);
                                            }
                                            else {
                                                $tabella->aggiungiNuovaRiga(array($documento["id"],$documento["numeroDocumento"],$dataEmissione,"<a href=\"creaDocumentoContabile.php?id={$documento["id"]}\"><b>{$documento["oggetto"]}</b></a>",$nomeClienteEscape,"<span class=\"text-$classe\">".$documento["totale"]."</span>"),$azioni);
                                            }
                                        }
                                        $tabella->stampa("rigaDocumento",0);
                                        $ricerca->stampaPaginazione(true,"documentiContabili.php?tipo=$tipo");
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </main>


            <div class="modal fade" id="modmodalEliminaDocumentoContabile" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare il documento?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <div class="align-self-center text-center">
                                    <span class="align-self-center text-primary"><em id="nomeElementoDaEliminare"></em></span>
                                </div>
                            </div>
                            <input type="text" class="d-none" id="elementoDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneDocumentoContabile()"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalCreaVocePrimaNota" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Crea voce prima nota</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
			    <form name="creaPrimaNotaModal" action="../controller/controllerDocumentiContabili.php" method="post">
				    <input type="text" class="d-none" name="operazione" value="crea">
				    <input type="text" class="d-none" name="tipo" value="prima nota">
				    <input type="text" class="d-none" name="imponibile" value="0">
				    <input type="text" class="d-none" name="iva" value="0">
				    <input type="text" class="d-none" name="giorniNecessari" value="0">
				    <input type="text" class="d-none" name="giorniValidita" value="0">
				    
				    <div class="row">
				        <div class="col-12">
				            <div class="form-group">
				                <label for="titolo-del-sito">Oggetto</label>
				                <input type="text" class="form-control" id="oggetto" name="oggetto" value="" placeholder="Oggetto">
				            </div>
				        </div>
				        
				        <div class="col-md-6">
				            <div class="form-group">
				                <label for="titolo-del-sito">Tipo</label>
				                <?php
				                	$arrayEntrataUscita = ["Entrata","Uscita"];
				                ?>
				                <select name="entrataUscita" class="form-control">
				                	<?php
				                		foreach($arrayEntrataUscita as $tipoDocumento) {
		                			?>
				                               	<option value="<?= $tipoDocumento ?>"><?= $tipoDocumento ?></option>
		                               	<?php
				                		}
				                	?>
				                </select>
				                <small class="form-text text-muted">Contrassegna come entrata i documenti emessi da te, come uscita quelli emessi a te da altri fornitori.</small>
				            </div>
				        </div>
				        
				        <div class="col-md-6">
				            <div class="form-group">
				                <label for="titolo-del-sito">Utente</label>
				                <select name="idUtente" class="form-control">
				                	<option value="0">Seleziona</option>
				                	<?php 
		                                            $query = "SELECT * FROM geec_utenti WHERE ruolo LIKE 'utente'";
		                                            $risEtichette = $geecomDb->eseguiQueryLettura($query);
		                                            while($utente = $risEtichette->fetch_assoc()) {
		                                                echo"<option value=\"{$utente["id"]}\">{$utente["nome"]} {$utente["cognome"]} - {$utente["organizzazione"]}</option>";
		                                            }
				                	?>
				                </select>
				            </div>
				        </div>
				        
				        <div class="col-md-4">
				            <div class="form-group">
				                <label for="titolo-del-sito">Totale €</label>
				                <input  type="number" step="0.01" class="form-control" id="totale" name="totale" value="0" placeholder="Totale">
				            </div>
				        </div>
				        
				        <div class="col-md-4">
				            <div class="form-group">
				                <label for="titolo-del-sito">Metodo pagamento</label>
				                <select id="modificaMetodoPagamento" name="metodoPagamento" class="form-control">
				                	<?php
		                                            $query = "SELECT * FROM geecAd_etichette WHERE tipo LIKE 'metodoPagamento'";
		                                            $risEtichette = $geecomDb->eseguiQueryLettura($query);
		                                            while($metodoPagamento = $risEtichette->fetch_assoc()) {
		                                                echo"<option value=\"{$metodoPagamento["nome"]}\">{$metodoPagamento["nome"]}</option>";
		                                            }
				                	?>
				                </select>
				            </div>
				        </div>
				        
				        <div class="col-md-4">
				            <div class="form-group">
				                <label for="titolo-del-sito">Data</label>
				                <input  type="date" class="form-control" id="dataPagamento" name="dataPagamento">
				            </div>
				        </div>
				        
				        <div class="col-12">
				            <div class="form-group">
				                <label for="titolo-del-sito">Note</label>
				                <textarea class="form-control" id="note" name="note"></textarea>
				            </div>
				        </div>
				    </div>
			    </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="document.creaPrimaNotaModal.submit()"><i class="fas fa-check"></i> Salva</button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal fade" id="modalModifcaVocePrimaNota" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Modifica voce prima nota</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
			    <form name="formModificaPrimaNota" action="../controller/controllerDocumentiContabili.php" method="post">
				    <input type="text" class="d-none" name="operazione" value="modifica">
				    <input type="text" class="d-none" id="idPrimaNotaDaModificare" name="id" value="0">
				    <input type="text" class="d-none" name="tipo" value="prima nota">
				    <input type="text" class="d-none" name="imponibile" value="0">
				    <input type="text" class="d-none" name="iva" value="0">
				    <input type="text" class="d-none" name="giorniNecessari" value="0">
				    <input type="text" class="d-none" name="giorniValidita" value="0">
				    
				    <div class="row">
				        <div class="col-12">
				            <div class="form-group">
				                <label for="titolo-del-sito">Oggetto</label>
				                <input type="text" class="form-control" id="modificaOggetto" name="oggetto" value="" placeholder="Oggetto">
				            </div>
				        </div>
				        
				        <div class="col-md-6">
				            <div class="form-group">
				                <label for="titolo-del-sito">Tipo</label>
				                <?php
				                	$arrayEntrataUscita = ["Entrata","Uscita"];
				                ?>
				                <select id="modificaEntrataUscita" name="entrataUscita" class="form-control">
				                	<?php
				                		foreach($arrayEntrataUscita as $tipoDocumento) {
		                			?>
				                               	<option value="<?= $tipoDocumento ?>"><?= $tipoDocumento ?></option>
		                               	<?php
				                		}
				                	?>
				                </select>
				                <small class="form-text text-muted">Contrassegna come entrata i documenti emessi da te, come uscita quelli emessi a te da altri fornitori.</small>
				            </div>
				        </div>
				        
				        <div class="col-md-6">
				            <div class="form-group">
				                <label for="titolo-del-sito">Utente</label>
				                <select id="modificaIdUtente" name="idUtente" class="form-control">
				                	<option value="0">Seleziona</option>
				                	<?php 
		                                            $query = "SELECT * FROM geec_utenti WHERE ruolo LIKE 'utente'";
		                                            $risEtichette = $geecomDb->eseguiQueryLettura($query);
		                                            while($utente = $risEtichette->fetch_assoc()) {
		                                                echo"<option value=\"{$utente["id"]}\">{$utente["nome"]} {$utente["cognome"]} - {$utente["organizzazione"]}</option>";
		                                            }
				                	?>
				                </select>
				            </div>
				        </div>
				        
				        <div class="col-md-4">
				            <div class="form-group">
				                <label for="titolo-del-sito">Totale €</label>
				                <input  type="number" step="0.01" class="form-control" id="modificaTotale" name="totale" value="0" placeholder="Totale">
				            </div>
				        </div>
				        
				        <div class="col-md-4">
				            <div class="form-group">
				                <label for="titolo-del-sito">Metodo pagamento</label>
				                <select name="metodoPagamento" class="form-control">
				                	<?php
		                                            $query = "SELECT * FROM geecAd_etichette WHERE tipo LIKE 'metodoPagamento'";
		                                            $risEtichette = $geecomDb->eseguiQueryLettura($query);
		                                            while($metodoPagamento = $risEtichette->fetch_assoc()) {
		                                                echo"<option value=\"{$metodoPagamento["nome"]}\">{$metodoPagamento["nome"]}</option>";
		                                            }
				                	?>
				                </select>
				            </div>
				        </div>
				        
				        <div class="col-md-4">
				            <div class="form-group">
				                <label for="titolo-del-sito">Data</label>
				                <input  type="date" class="form-control" id="modificaDataPagamento" name="dataPagamento">
				            </div>
				        </div>
				        
				        <div class="col-12">
				            <div class="form-group">
				                <label for="titolo-del-sito">Note</label>
				                <textarea class="form-control" id="note" name="note"></textarea>
				            </div>
				        </div>
				    </div>
			    </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="document.formModificaPrimaNota.submit()"><i class="fas fa-check"></i> Salva</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php 
            include "include/footer.php";

            include "include/modal/cambiaPassword.php";

            include "include/modal/modalMenuComponenti.php";

            include "include/modal/operazioneCompletata.php";

            include "include/jsBaseAreaAmministrativa.php";
        ?>



        <script type="text/javascript">

                function eliminaDocumentoContabile(id,nomeElemento) {
                    $('#elementoDaEliminare').val(id);
                    $('#nomeElementoDaEliminare').text(nomeElemento);
                    $('#modmodalEliminaDocumentoContabile').modal('show');
                }

                function eseguiEliminazioneDocumentoContabile() {
                    var id = $('#elementoDaEliminare').val();
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerDocumentiContabili.php",
                        data:{
                            operazione:"elimina",
                            id:id
                        },
                        success:function(result) {
                            if(result=="ok") {
                                document.getElementById("rigaDocumento"+id).className = "d-none";
                                $('#modmodalEliminaDocumentoContabile').modal('hide');
                            }
                            else {
                                alert(result);
                            }
                        },
                        error: function() {
                            alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }
                
                function modificaPrimaNota(id,oggetto,entrataUscita,idUtente,totale,metodoPagamento,dataPagamento,note) {
                    $('#idPrimaNotaDaModificare').val(id);
                    $('#modificaOggetto').val(oggetto);
                    $('#modificaEntrataUscita').val(entrataUscita);
                    $('#modificaIdUtente').val(idUtente);
                    $('#modificaTotale').val(totale);
                    $('#modificaMetodoPagamento').val(metodoPagamento);
                    $('#modificaNote').val(note);
                    $('#modificaDataPagamento').val(dataPagamento);
                    $('#modalModifcaVocePrimaNota').modal('show');
                }
        </script>
    </body>
</html>
